<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="https://fonts.googleapis.com/css2?family=Athiti&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" integrity="sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z" crossorigin="anonymous">
    <link href="https://fonts.googleapis.com/css2?family=Kanit&display=swap" rel="stylesheet">


    <title>Login</title>
  </head>
  
<style type="text/css">
body { 
    background: black; 
    background-size: cover;
    font-family: 'Kanit', sans-serif;
}

.login-box {
    width: 100%;
    margin: auto;
    max-width: 525px;
    min-height: 100px;
    position: relative;
   

}

.login-snip .login,
.login-snip .sign-up-form {
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    position: absolute;
    transform: rotateY(180deg);
    backface-visibility: hidden;
    transition: all .4s linear
}

.login-snip .sign-in,
.login-snip .sign-up,
.login-space .group .check {
    display: none
}

.login-snip .tab,
.login-space .group .label,
.login-space .group .button {
    text-transform: uppercase
}

.login-snip .tab {
   
    margin-right: 15px;
    padding-bottom: 5px;
    margin: 0 15px 10px 0;
    display: inline-block;
    border-bottom: 2px solid transparent
}

.login-snip .sign-in:checked+.tab,
.login-snip .sign-up:checked+.tab {
    color: #fff;
    border-color: #1161ee
}

.login-space {
    min-height: 345px;
    position: relative;
    perspective: 1000px;
    transform-style: preserve-3d
}

.login-space .group {
    margin-bottom: 15px
}

.login-space .group .label,
.login-space .group .input,
.login-space .group .button {
    width: 100%;
    color: black;
    display: block
}

.login-space .group .input,
.login-space .group .button {
    border: none;
    padding: 15px 20px;
    border-radius: 25px;
    background: rgba(255, 255, 255, .1)
}

.login-space .group input[data-type="password"] {
    -webkit-text-security: circle
}

.login-space .group .label {
    color: #aaa;
    font-size: 12px
}

.login-space .group .button {
    background: blue;
}

.login-space .group label .icon {
    width: 15px;
    height: 15px;
    border-radius: 2px;
    position: relative;
    display: inline-block;
    background: rgba(255, 255, 255, .1)
}

.login-space .group label .icon:before,
.login-space .group label .icon:after {
    content: '';
    width: 10px;
    height: 2px;
    background: #fff;
    position: absolute;
    transition: all .2s ease-in-out 0s
}

.login-space .group label .icon:before {
    left: 3px;
    width: 5px;
    bottom: 6px;
    transform: scale(0) rotate(0)
}

.login-space .group label .icon:after {
    top: 6px;
    right: 0;
    transform: scale(0) rotate(0)
}

.login-space .group .check:checked+label {
    color: #fff
}

.login-space .group .check:checked+label .icon {
    background: #1161ee
}

.login-space .group .check:checked+label .icon:before {
    transform: scale(1) rotate(45deg)
}

.login-space .group .check:checked+label .icon:after {
    transform: scale(1) rotate(-45deg)
}

.login-snip .sign-in:checked+.tab+.sign-up+.tab+.login-space .login {
    transform: rotate(0)
}

.login-snip .sign-up:checked+.tab+.login-space .sign-up-form {
    transform: rotate(0)
}

*,
:after,
:before {
    box-sizing: border-box
}

.clearfix:after,
.clearfix:before {
    content: '';
    display: table
}

.clearfix:after {
    clear: both;
    display: block
}

a {
    color: inherit;
    text-decoration: none
}

.hr {
    height: 2px;
    margin: 60px 0 50px 0;
    background: rgba(255, 255, 255, .2)
}

.foot {
    text-align: center
}

.card {
    width: 500px;
    left: 100px
}

::placeholder {
    color: black;
}

.buttonmove {
  border-radius: 4px;
  background-color: #f4511e;
  border: none;
  color: #FFFFFF;
  text-align: center;
  font-size: 28px;
  padding: 20px;
  width: 200px;
  transition: all 0.5s;
  cursor: pointer;
  margin: 5px;
}

.buttonmove span {
  cursor: pointer;
  display: inline-block;
  position: relative;
  transition: 0.5s;
}

.buttonmove span:after {
  content: '\00bb';
  position: absolute;
  opacity: 0;
  top: 0;
  right: -20px;
  transition: 0.5s;
}

.buttonmove:hover span {
  padding-right: 25px;
}

.buttonmove:hover span:after {
  opacity: 1;
  right: 0;
}
#img{
    width: 40%;
    position: relative;
    top:-3;
    left: 150px; 
    z-index: 999;
}
.font-size{
    font-size: 30px;
}


@media screen and (max-width: 450px) {
  #img
    {
        width: 40%;
        position: relative;
        top:-3;
        left: 106px; 
        z-index: 999;
    }
   .font-size{
     font-size: 22px;
   } 
}
@media screen and (max-width: 360px) {
  #img
    {
        width: 40%;
        position: relative;
        top:-3;
        left: 86px; 
        z-index: 999;
    }
   .font-size{
     font-size: 18px;
   } 
}

  </style>
  <body>


<div class="container" >
  <div class="row align-items-center">
    <div class="col login-box">
      

                 
    </div>
    
  </div>
</div>

  <div class="container-fluid" >
  <div class="row align-items-center">
        <div class="col-sm-12 col-md-12 mx-auto" >
            <div class="login-box" >
             
                <div class="login-snip" > 

                    <input id="tab-1" type="radio" name="tab" class="sign-in" checked><label for="tab-1" class="tab font-size" style="cursor: pointer;">เข้าสู่ระบบ</label>
                    <input id="tab-2" type="radio" name="tab" class="sign-up"><label for="tab-2" class="tab font-size" style="cursor: pointer;display: none;">สมัครสมาชิก</label>
                        
                        <div class="login-space" >
                            <div class="login">
                                <div class="group mt-0">
                                    <label for="user" class="label" style="font-size: 20px;color: white;">ชื่อสมาชิก</label> <input id="user" type="text" class="input" style="font-family: 'Kanit', sans-serif;background-color: #E8F0FE;" placeholder="กรอกชื่อสมาชิก"> </div>
                                <div class="group mt-4"> <label for="pass" class="label" style="font-size: 20px;color: white;">รหัสผ่าน</label> <input id="pass" type="password"  style="font-family: 'Kanit', sans-serif;background-color: #E8F0FE;" class="input" data-type="password" placeholder="กรอกรหัสผ่าน"> </div>
                                <div class="group mt-0" onclick="login();"> <button class="buttonmove button" style="cursor: pointer;font-family: 'Kanit', sans-serif;font-size: 20px;width:100%;height: 50px;padding: 1px;margin-top: 50px;color: white;"  value="submit"><span>เข้าสู่ระบบ </span></button> </div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>

   
</div>

    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
<script type="application/javascript" src="assets/js/jquery-3.2.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js" integrity="sha384-B4gt1jrGC7Jh4AgTPSdUtOBvfO8shuf57BaghqFfPlYxofvL8/KUEfYiJOMMV+rV" crossorigin="anonymous"></script>


<script>
    function login(){
        var user = $('#user').val();
        var pass = $('#pass').val();

        if(user =="" || pass =="")
        {
          alert("กรุณาระบุชื่อสมาชิก และ รหัสผ่าน");
          return false;  
        }
     
        $.ajax({
                type : "POST",
                url  : "login_sub.php",
                data:{user:user,pass:pass},
                success:function(data){
                    var obj= JSON.parse(data);
                    if(obj.status == "success"){
                        location.href = "index.php";
                    }
                    else{
                        alert("กรุณากรอกข้อมูลให้ถูกต้อง");
                    }
                   
                }

        });
    }
    </script>
   
  </body>
</html>